/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.objects.blocks.BlockPlacedItem;
import net.dries007.tfc.objects.items.ItemAnimalHide;
import net.dries007.tfc.objects.te.TEPlacedHide;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockPlacedHide
extends Block {
    public static final PropertyEnum<ItemAnimalHide.HideSize> SIZE = PropertyEnum.func_177709_a((String)"size", ItemAnimalHide.HideSize.class);

    public BlockPlacedHide() {
        super(Material.field_151594_q);
        this.func_149711_c(0.2f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(SIZE, (Comparable)((Object)ItemAnimalHide.HideSize.MEDIUM)));
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SIZE, (Comparable)((Object)ItemAnimalHide.HideSize.valueOf(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((ItemAnimalHide.HideSize)((Object)state.func_177229_b(SIZE))).ordinal();
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BlockPlacedItem.PLACED_ITEM_AABB;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BlockPlacedItem.PLACED_ITEM_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return BlockPlacedItem.PLACED_ITEM_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.getItemStackDropped((IBlockAccess)worldIn, pos, state));
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (OreDictionaryHelper.doesStackMatchOre(stack, "knife")) {
            if (!worldIn.field_72995_K) {
                Vec3d point = BlockPlacedHide.calculatePoint(playerIn.func_70040_Z(), new Vec3d((double)hitX, (double)hitY, (double)hitZ));
                stack.func_77972_a(1, (EntityLivingBase)playerIn);
                TEPlacedHide tile = Helpers.getTE((IBlockAccess)worldIn, pos, TEPlacedHide.class);
                if (tile != null) {
                    tile.onClicked((float)point.field_72450_a, (float)point.field_72449_c);
                }
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    private static Vec3d calculatePoint(Vec3d rayVector, Vec3d rayPoint) {
        Vec3d planeNormal = new Vec3d(0.0, 1.0, 0.0);
        return rayPoint.func_178788_d(rayVector.func_186678_a(rayPoint.func_72430_b(planeNormal) / rayVector.func_72430_b(planeNormal)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIZE});
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEPlacedHide();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getItemStackDropped((IBlockAccess)world, pos, state);
    }

    private ItemStack getItemStackDropped(IBlockAccess world, BlockPos pos, IBlockState state) {
        TEPlacedHide tile = Helpers.getTE(world, pos, TEPlacedHide.class);
        if (tile != null && tile.isComplete()) {
            return new ItemStack((Item)ItemAnimalHide.get(ItemAnimalHide.HideType.SCRAPED, (ItemAnimalHide.HideSize)((Object)state.func_177229_b(SIZE))));
        }
        return new ItemStack((Item)ItemAnimalHide.get(ItemAnimalHide.HideType.SOAKED, (ItemAnimalHide.HideSize)((Object)state.func_177229_b(SIZE))));
    }
}

